<?php
/**
 * The template to display Admin notices
 *
 * @package MIDI
 * @since MIDI 1.0.64
 */

$midi_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$midi_skins_args = get_query_var( 'midi_skins_notice_args' );
?>
<div class="midi_admin_notice midi_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$midi_theme_img = midi_get_file_url( 'screenshot.jpg' );
	if ( '' != $midi_theme_img ) {
		?>
		<div class="midi_notice_image"><img src="<?php echo esc_url( $midi_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'midi' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="midi_notice_title">
		<?php esc_html_e( 'New skins are available', 'midi' ); ?>
	</h3>
	<?php

	// Description
	$midi_total      = $midi_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$midi_skins_msg  = $midi_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $midi_total, 'midi' ), $midi_total ) . '</strong>'
							: '';
	$midi_total      = $midi_skins_args['free'];
	$midi_skins_msg .= $midi_total > 0
							? ( ! empty( $midi_skins_msg ) ? ' ' . esc_html__( 'and', 'midi' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $midi_total, 'midi' ), $midi_total ) . '</strong>'
							: '';
	$midi_total      = $midi_skins_args['pay'];
	$midi_skins_msg .= $midi_skins_args['pay'] > 0
							? ( ! empty( $midi_skins_msg ) ? ' ' . esc_html__( 'and', 'midi' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $midi_total, 'midi' ), $midi_total ) . '</strong>'
							: '';
	?>
	<div class="midi_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'midi' ), $midi_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="midi_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $midi_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'midi' );
			?>
		</a>
	</div>
</div>
