<?php
/**
 * The template to display the widgets area in the header
 *
 * @package MIDI
 * @since MIDI 1.0
 */

// Header sidebar
$midi_header_name    = midi_get_theme_option( 'header_widgets' );
$midi_header_present = ! midi_is_off( $midi_header_name ) && is_active_sidebar( $midi_header_name );
if ( $midi_header_present ) {
	midi_storage_set( 'current_sidebar', 'header' );
	$midi_header_wide = midi_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $midi_header_name ) ) {
		dynamic_sidebar( $midi_header_name );
	}
	$midi_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $midi_widgets_output ) ) {
		$midi_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $midi_widgets_output );
		$midi_need_columns   = strpos( $midi_widgets_output, 'columns_wrap' ) === false;
		if ( $midi_need_columns ) {
			$midi_columns = max( 0, (int) midi_get_theme_option( 'header_columns' ) );
			if ( 0 == $midi_columns ) {
				$midi_columns = min( 6, max( 1, midi_tags_count( $midi_widgets_output, 'aside' ) ) );
			}
			if ( $midi_columns > 1 ) {
				$midi_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $midi_columns ) . ' widget', $midi_widgets_output );
			} else {
				$midi_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $midi_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'midi_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $midi_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $midi_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'midi_action_before_sidebar', 'header' );
				midi_show_layout( $midi_widgets_output );
				do_action( 'midi_action_after_sidebar', 'header' );
				if ( $midi_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $midi_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'midi_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
