<?php
/**
 * The template to display default site header
 *
 * @package MIDI
 * @since MIDI 1.0
 */

$midi_header_css   = '';
$midi_header_image = get_header_image();
$midi_header_video = midi_get_header_video();
if ( ! empty( $midi_header_image ) && midi_trx_addons_featured_image_override( is_singular() || midi_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$midi_header_image = midi_get_current_mode_image( $midi_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $midi_header_image ) || ! empty( $midi_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $midi_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $midi_header_image ) {
		echo ' ' . esc_attr( midi_add_inline_css_class( 'background-image: url(' . esc_url( $midi_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( midi_is_on( midi_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight midi-full-height';
	}
	$midi_header_scheme = midi_get_theme_option( 'header_scheme' );
	if ( ! empty( $midi_header_scheme ) && ! midi_is_inherit( $midi_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $midi_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $midi_header_video ) ) {
		get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( midi_is_on( midi_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
