<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package MIDI
 * @since MIDI 1.0.10
 */

// Footer sidebar
$midi_footer_name    = midi_get_theme_option( 'footer_widgets' );
$midi_footer_present = ! midi_is_off( $midi_footer_name ) && is_active_sidebar( $midi_footer_name );
if ( $midi_footer_present ) {
	midi_storage_set( 'current_sidebar', 'footer' );
	$midi_footer_wide = midi_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $midi_footer_name ) ) {
		dynamic_sidebar( $midi_footer_name );
	}
	$midi_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $midi_out ) ) {
		$midi_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $midi_out );
		$midi_need_columns = true;   //or check: strpos($midi_out, 'columns_wrap')===false;
		if ( $midi_need_columns ) {
			$midi_columns = max( 0, (int) midi_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $midi_columns ) {
				$midi_columns = min( 4, max( 1, midi_tags_count( $midi_out, 'aside' ) ) );
			}
			if ( $midi_columns > 1 ) {
				$midi_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $midi_columns ) . ' widget', $midi_out );
			} else {
				$midi_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $midi_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'midi_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $midi_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $midi_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'midi_action_before_sidebar', 'footer' );
				midi_show_layout( $midi_out );
				do_action( 'midi_action_after_sidebar', 'footer' );
				if ( $midi_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $midi_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'midi_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
