<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package MIDI
 * @since MIDI 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$midi_copyright_scheme = midi_get_theme_option( 'copyright_scheme' );
if ( ! empty( $midi_copyright_scheme ) && ! midi_is_inherit( $midi_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $midi_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$midi_copyright = midi_get_theme_option( 'copyright' );
			if ( ! empty( $midi_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$midi_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $midi_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$midi_copyright = midi_prepare_macros( $midi_copyright );
				// Display copyright
				echo wp_kses( nl2br( $midi_copyright ), 'midi_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
