<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package MIDI
 * @since MIDI 1.0
 */

$midi_template_args = get_query_var( 'midi_template_args' );
if ( is_array( $midi_template_args ) ) {
	$midi_columns    = empty( $midi_template_args['columns'] ) ? 2 : max( 1, $midi_template_args['columns'] );
	$midi_blog_style = array( $midi_template_args['type'], $midi_columns );
    $midi_columns_class = midi_get_column_class( 1, $midi_columns, ! empty( $midi_template_args['columns_tablet']) ? $midi_template_args['columns_tablet'] : '', ! empty($midi_template_args['columns_mobile']) ? $midi_template_args['columns_mobile'] : '' );
} else {
	$midi_template_args = array();
	$midi_blog_style = explode( '_', midi_get_theme_option( 'blog_style' ) );
	$midi_columns    = empty( $midi_blog_style[1] ) ? 2 : max( 1, $midi_blog_style[1] );
    $midi_columns_class = midi_get_column_class( 1, $midi_columns );
}

$midi_post_format = get_post_format();
$midi_post_format = empty( $midi_post_format ) ? 'standard' : str_replace( 'post-format-', '', $midi_post_format );

?><div class="
<?php
if ( ! empty( $midi_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( midi_is_blog_style_use_masonry( $midi_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $midi_columns ) : esc_attr( $midi_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $midi_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $midi_columns )
		. ( 'portfolio' != $midi_blog_style[0] ? ' ' . esc_attr( $midi_blog_style[0] )  . '_' . esc_attr( $midi_columns ) : '' )
	);
	midi_add_blog_animation( $midi_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$midi_hover   = ! empty( $midi_template_args['hover'] ) && ! midi_is_inherit( $midi_template_args['hover'] )
								? $midi_template_args['hover']
								: midi_get_theme_option( 'image_hover' );

	if ( 'dots' == $midi_hover ) {
		$midi_post_link = empty( $midi_template_args['no_links'] )
								? ( ! empty( $midi_template_args['link'] )
									? $midi_template_args['link']
									: get_permalink()
									)
								: '';
		$midi_target    = ! empty( $midi_post_link ) && midi_is_external_url( $midi_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$midi_components = ! empty( $midi_template_args['meta_parts'] )
							? ( is_array( $midi_template_args['meta_parts'] )
								? $midi_template_args['meta_parts']
								: explode( ',', $midi_template_args['meta_parts'] )
								)
							: midi_array_get_keys_by_value( midi_get_theme_option( 'meta_parts' ) );

	// Featured image
	midi_show_post_featured( apply_filters( 'midi_filter_args_featured',
        array(
			'hover'         => $midi_hover,
			'no_links'      => ! empty( $midi_template_args['no_links'] ),
			'thumb_size'    => ! empty( $midi_template_args['thumb_size'] )
								? $midi_template_args['thumb_size']
								: midi_get_thumb_size(
									midi_is_blog_style_use_masonry( $midi_blog_style[0] )
										? (	strpos( midi_get_theme_option( 'body_style' ), 'full' ) !== false || $midi_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( midi_get_theme_option( 'body_style' ), 'full' ) !== false || $midi_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => midi_is_blog_style_use_masonry( $midi_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $midi_components,
			'class'         => 'dots' == $midi_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $midi_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $midi_post_link )
												? '<a href="' . esc_url( $midi_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $midi_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $midi_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $midi_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!