<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package MIDI
 * @since MIDI 1.0.50
 */

$midi_template_args = get_query_var( 'midi_template_args' );
if ( is_array( $midi_template_args ) ) {
	$midi_columns    = empty( $midi_template_args['columns'] ) ? 2 : max( 1, $midi_template_args['columns'] );
	$midi_blog_style = array( $midi_template_args['type'], $midi_columns );
} else {
	$midi_template_args = array();
	$midi_blog_style = explode( '_', midi_get_theme_option( 'blog_style' ) );
	$midi_columns    = empty( $midi_blog_style[1] ) ? 2 : max( 1, $midi_blog_style[1] );
}
$midi_blog_id       = midi_get_custom_blog_id( join( '_', $midi_blog_style ) );
$midi_blog_style[0] = str_replace( 'blog-custom-', '', $midi_blog_style[0] );
$midi_expanded      = ! midi_sidebar_present() && midi_get_theme_option( 'expand_content' ) == 'expand';
$midi_components    = ! empty( $midi_template_args['meta_parts'] )
							? ( is_array( $midi_template_args['meta_parts'] )
								? join( ',', $midi_template_args['meta_parts'] )
								: $midi_template_args['meta_parts']
								)
							: midi_array_get_keys_by_value( midi_get_theme_option( 'meta_parts' ) );
$midi_post_format   = get_post_format();
$midi_post_format   = empty( $midi_post_format ) ? 'standard' : str_replace( 'post-format-', '', $midi_post_format );

$midi_blog_meta     = midi_get_custom_layout_meta( $midi_blog_id );
$midi_custom_style  = ! empty( $midi_blog_meta['scripts_required'] ) ? $midi_blog_meta['scripts_required'] : 'none';

if ( ! empty( $midi_template_args['slider'] ) || $midi_columns > 1 || ! midi_is_off( $midi_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $midi_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( midi_is_off( $midi_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $midi_custom_style ) ) . "-1_{$midi_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $midi_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $midi_columns )
					. ' post_layout_' . esc_attr( $midi_blog_style[0] )
					. ' post_layout_' . esc_attr( $midi_blog_style[0] ) . '_' . esc_attr( $midi_columns )
					. ( ! midi_is_off( $midi_custom_style )
						? ' post_layout_' . esc_attr( $midi_custom_style )
							. ' post_layout_' . esc_attr( $midi_custom_style ) . '_' . esc_attr( $midi_columns )
						: ''
						)
		);
	midi_add_blog_animation( $midi_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'midi_action_show_layout', $midi_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $midi_template_args['slider'] ) || $midi_columns > 1 || ! midi_is_off( $midi_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
