<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package MIDI
 * @since MIDI 1.71.0
 */
?>

<div class="author_page author vcard"<?php
	if ( midi_is_on( midi_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( midi_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( midi_is_on( midi_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
		}
	?>>
		<?php
		$midi_mult = midi_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $midi_mult );
		?>
	</div>

	<h4 class="author_title"<?php
		if ( midi_is_on( midi_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="name"<?php
		}
	?>><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$midi_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $midi_author_description ) ) {
		?>
		<div class="author_bio"<?php
			if ( midi_is_on( midi_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>><?php echo wp_kses( wpautop( $midi_author_description ), 'midi_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$midi_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );
			if ( $midi_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $midi_posts_total, 'midi' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $midi_posts_total ) . '</span>'
								 		),
							'midi_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'midi' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'midi_action_user_meta', 'author-page' );
			$midi_socials = ob_get_contents();
			ob_end_clean();
			midi_show_layout( $midi_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'midi' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
