<?php
/**
 * The template to display Admin notices
 *
 * @package MIDI
 * @since MIDI 1.0.1
 */

$midi_theme_slug = get_option( 'template' );
$midi_theme_obj  = wp_get_theme( $midi_theme_slug );
?>
<div class="midi_admin_notice midi_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$midi_theme_img = midi_get_file_url( 'screenshot.jpg' );
	if ( '' != $midi_theme_img ) {
		?>
		<div class="midi_notice_image"><img src="<?php echo esc_url( $midi_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'midi' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="midi_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'midi' ),
				$midi_theme_obj->get( 'Name' ) . ( MIDI_THEME_FREE ? ' ' . __( 'Free', 'midi' ) : '' ),
				$midi_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="midi_notice_text">
		<p class="midi_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $midi_theme_obj->description ) );
			?>
		</p>
		<p class="midi_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'midi' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="midi_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=midi_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'midi' );
			?>
		</a>
	</div>
</div>
