<?php
/**
 * The template to display single post
 *
 * @package MIDI
 * @since MIDI 1.0
 */

// Full post loading
$full_post_loading          = midi_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = midi_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = midi_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$midi_related_position   = midi_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$midi_posts_navigation   = midi_get_theme_option( 'posts_navigation' );
$midi_prev_post          = false;
$midi_prev_post_same_cat = (int)midi_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( midi_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	midi_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'midi_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $midi_posts_navigation ) {
		$midi_prev_post = get_previous_post( $midi_prev_post_same_cat );  // Get post from same category
		if ( ! $midi_prev_post && $midi_prev_post_same_cat ) {
			$midi_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $midi_prev_post ) {
			$midi_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $midi_prev_post ) ) {
		midi_sc_layouts_showed( 'featured', false );
		midi_sc_layouts_showed( 'title', false );
		midi_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $midi_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/content', 'single-' . midi_get_theme_option( 'single_style' ) ), 'single-' . midi_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $midi_related_position, 'inside' ) === 0 ) {
		$midi_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'midi_action_related_posts' );
		$midi_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $midi_related_content ) ) {
			$midi_related_position_inside = max( 0, min( 9, midi_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $midi_related_position_inside ) {
				$midi_related_position_inside = mt_rand( 1, 9 );
			}

			$midi_p_number         = 0;
			$midi_related_inserted = false;
			$midi_in_block         = false;
			$midi_content_start    = strpos( $midi_content, '<div class="post_content' );
			$midi_content_end      = strrpos( $midi_content, '</div>' );

			for ( $i = max( 0, $midi_content_start ); $i < min( strlen( $midi_content ) - 3, $midi_content_end ); $i++ ) {
				if ( $midi_content[ $i ] != '<' ) {
					continue;
				}
				if ( $midi_in_block ) {
					if ( strtolower( substr( $midi_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$midi_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $midi_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $midi_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$midi_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $midi_content[ $i + 1 ] && in_array( $midi_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$midi_p_number++;
					if ( $midi_related_position_inside == $midi_p_number ) {
						$midi_related_inserted = true;
						$midi_content = ( $i > 0 ? substr( $midi_content, 0, $i ) : '' )
											. $midi_related_content
											. substr( $midi_content, $i );
					}
				}
			}
			if ( ! $midi_related_inserted ) {
				if ( $midi_content_end > 0 ) {
					$midi_content = substr( $midi_content, 0, $midi_content_end ) . $midi_related_content . substr( $midi_content, $midi_content_end );
				} else {
					$midi_content .= $midi_related_content;
				}
			}
		}

		midi_show_layout( $midi_content );
	}

	// Comments
	do_action( 'midi_action_before_comments' );
	comments_template();
	do_action( 'midi_action_after_comments' );

	// Related posts
	if ( 'below_content' == $midi_related_position
		&& ( 'scroll' != $midi_posts_navigation || (int)midi_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)midi_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'midi_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $midi_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $midi_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $midi_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $midi_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'midi_action_nav_links_single_scroll_data', $midi_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
