<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package MIDI
 * @since MIDI 1.0
 */

if ( midi_sidebar_present() ) {
	
	$midi_sidebar_type = midi_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $midi_sidebar_type && ! midi_is_layouts_available() ) {
		$midi_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $midi_sidebar_type ) {
		// Default sidebar with widgets
		$midi_sidebar_name = midi_get_theme_option( 'sidebar_widgets' );
		midi_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $midi_sidebar_name ) ) {
			dynamic_sidebar( $midi_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$midi_sidebar_id = midi_get_custom_sidebar_id();
		do_action( 'midi_action_show_layout', $midi_sidebar_id );
	}
	$midi_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $midi_out ) ) {
		$midi_sidebar_position    = midi_get_theme_option( 'sidebar_position' );
		$midi_sidebar_position_ss = midi_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $midi_sidebar_position );
			echo ' sidebar_' . esc_attr( $midi_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $midi_sidebar_type );

			$midi_sidebar_scheme = apply_filters( 'midi_filter_sidebar_scheme', midi_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $midi_sidebar_scheme ) && ! midi_is_inherit( $midi_sidebar_scheme ) && 'custom' != $midi_sidebar_type ) {
				echo ' scheme_' . esc_attr( $midi_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="midi_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'midi_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $midi_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$midi_title = apply_filters( 'midi_filter_sidebar_control_title', 'float' == $midi_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'midi' ) : '' );
				$midi_text  = apply_filters( 'midi_filter_sidebar_control_text', 'above' == $midi_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'midi' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $midi_title ); ?>"><?php echo esc_html( $midi_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'midi_action_before_sidebar', 'sidebar' );
				midi_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $midi_out ) );
				do_action( 'midi_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'midi_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
