<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package MIDI
 * @since MIDI 1.0
 */

$midi_template = apply_filters( 'midi_filter_get_template_part', midi_blog_archive_get_template() );

if ( ! empty( $midi_template ) && 'index' != $midi_template ) {

	get_template_part( $midi_template );

} else {

	midi_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$midi_stickies   = is_home()
								|| ( in_array( midi_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) midi_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$midi_post_type  = midi_get_theme_option( 'post_type' );
		$midi_args       = array(
								'blog_style'     => midi_get_theme_option( 'blog_style' ),
								'post_type'      => $midi_post_type,
								'taxonomy'       => midi_get_post_type_taxonomy( $midi_post_type ),
								'parent_cat'     => midi_get_theme_option( 'parent_cat' ),
								'posts_per_page' => midi_get_theme_option( 'posts_per_page' ),
								'sticky'         => midi_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $midi_stickies )
															&& count( $midi_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		midi_blog_archive_start();

		do_action( 'midi_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'midi_action_before_page_author' );
			get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'midi_action_after_page_author' );
		}

		if ( midi_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'midi_action_before_page_filters' );
			midi_show_filters( $midi_args );
			do_action( 'midi_action_after_page_filters' );
		} else {
			do_action( 'midi_action_before_page_posts' );
			midi_show_posts( array_merge( $midi_args, array( 'cat' => $midi_args['parent_cat'] ) ) );
			do_action( 'midi_action_after_page_posts' );
		}

		do_action( 'midi_action_blog_archive_end' );

		midi_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
