<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package MIDI
 * @since MIDI 1.0
 */

// Page (category, tag, archive, author) title

if ( midi_need_page_title() ) {
	midi_sc_layouts_showed( 'title', true );
	midi_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								midi_show_post_meta(
									apply_filters(
										'midi_filter_post_meta_args', array(
											'components' => join( ',', midi_array_get_keys_by_value( midi_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', midi_array_get_keys_by_value( midi_get_theme_option( 'counters' ) ) ),
											'seo'        => midi_is_on( midi_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$midi_blog_title           = midi_get_blog_title();
							$midi_blog_title_text      = '';
							$midi_blog_title_class     = '';
							$midi_blog_title_link      = '';
							$midi_blog_title_link_text = '';
							if ( is_array( $midi_blog_title ) ) {
								$midi_blog_title_text      = $midi_blog_title['text'];
								$midi_blog_title_class     = ! empty( $midi_blog_title['class'] ) ? ' ' . $midi_blog_title['class'] : '';
								$midi_blog_title_link      = ! empty( $midi_blog_title['link'] ) ? $midi_blog_title['link'] : '';
								$midi_blog_title_link_text = ! empty( $midi_blog_title['link_text'] ) ? $midi_blog_title['link_text'] : '';
							} else {
								$midi_blog_title_text = $midi_blog_title;
							}
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr( $midi_blog_title_class ); ?>"<?php
								if ( midi_is_on( midi_get_theme_option( 'seo_snippets' ) ) ) {
									?> itemprop="headline"<?php
								}
							?>>
								<?php
								$midi_top_icon = midi_get_term_image_small();
								if ( ! empty( $midi_top_icon ) ) {
									$midi_attr = midi_getimagesize( $midi_top_icon );
									?>
									<img src="<?php echo esc_url( $midi_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'midi' ); ?>"
										<?php
										if ( ! empty( $midi_attr[3] ) ) {
											midi_show_layout( $midi_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $midi_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $midi_blog_title_link ) && ! empty( $midi_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $midi_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $midi_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'midi_action_breadcrumbs' );
						$midi_breadcrumbs = ob_get_contents();
						ob_end_clean();
						midi_show_layout( $midi_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
