<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package MIDI
 * @since MIDI 1.0
 */

$midi_args = get_query_var( 'midi_logo_args' );

// Site logo
$midi_logo_type   = isset( $midi_args['type'] ) ? $midi_args['type'] : '';
$midi_logo_image  = midi_get_logo_image( $midi_logo_type );
$midi_logo_text   = midi_is_on( midi_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$midi_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $midi_logo_image['logo'] ) || ! empty( $midi_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $midi_logo_image['logo'] ) ) {
			if ( empty( $midi_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($midi_logo_image['logo']) && (int) $midi_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$midi_attr = midi_getimagesize( $midi_logo_image['logo'] );
				echo '<img src="' . esc_url( $midi_logo_image['logo'] ) . '"'
						. ( ! empty( $midi_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $midi_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $midi_logo_text ) . '"'
						. ( ! empty( $midi_attr[3] ) ? ' ' . wp_kses_data( $midi_attr[3] ) : '' )
						. '>';
			}
		} else {
			midi_show_layout( midi_prepare_macros( $midi_logo_text ), '<span class="logo_text">', '</span>' );
			midi_show_layout( midi_prepare_macros( $midi_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
