<?php
/**
 * The template to display the site logo in the footer
 *
 * @package MIDI
 * @since MIDI 1.0.10
 */

// Logo
if ( midi_is_on( midi_get_theme_option( 'logo_in_footer' ) ) ) {
	$midi_logo_image = midi_get_logo_image( 'footer' );
	$midi_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $midi_logo_image['logo'] ) || ! empty( $midi_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $midi_logo_image['logo'] ) ) {
					$midi_attr = midi_getimagesize( $midi_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $midi_logo_image['logo'] ) . '"'
								. ( ! empty( $midi_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $midi_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'midi' ) . '"'
								. ( ! empty( $midi_attr[3] ) ? ' ' . wp_kses_data( $midi_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $midi_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $midi_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
