<?php
/**
 * The template to display default site footer
 *
 * @package MIDI
 * @since MIDI 1.0.10
 */

$midi_footer_id = midi_get_custom_footer_id();
$midi_footer_meta = get_post_meta( $midi_footer_id, 'trx_addons_options', true );
if ( ! empty( $midi_footer_meta['margin'] ) ) {
	midi_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( midi_prepare_css_value( $midi_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $midi_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $midi_footer_id ) ) ); ?>
						<?php
						$midi_footer_scheme = midi_get_theme_option( 'footer_scheme' );
						if ( ! empty( $midi_footer_scheme ) && ! midi_is_inherit( $midi_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $midi_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'midi_action_show_layout', $midi_footer_id );
	?>
</footer><!-- /.footer_wrap -->
