<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package MIDI
 * @since MIDI 1.0
 */

$midi_template_args = get_query_var( 'midi_template_args' );
$midi_columns = 1;
if ( is_array( $midi_template_args ) ) {
	$midi_columns    = empty( $midi_template_args['columns'] ) ? 1 : max( 1, $midi_template_args['columns'] );
	$midi_blog_style = array( $midi_template_args['type'], $midi_columns );
	if ( ! empty( $midi_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $midi_columns > 1 ) {
	    $midi_columns_class = midi_get_column_class( 1, $midi_columns, ! empty( $midi_template_args['columns_tablet']) ? $midi_template_args['columns_tablet'] : '', ! empty($midi_template_args['columns_mobile']) ? $midi_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $midi_columns_class ); ?>">
		<?php
	}
} else {
	$midi_template_args = array();
}
$midi_expanded    = ! midi_sidebar_present() && midi_get_theme_option( 'expand_content' ) == 'expand';
$midi_post_format = get_post_format();
$midi_post_format = empty( $midi_post_format ) ? 'standard' : str_replace( 'post-format-', '', $midi_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $midi_post_format ) );
	midi_add_blog_animation( $midi_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$midi_hover      = ! empty( $midi_template_args['hover'] ) && ! midi_is_inherit( $midi_template_args['hover'] )
							? $midi_template_args['hover']
							: midi_get_theme_option( 'image_hover' );
	$midi_components = ! empty( $midi_template_args['meta_parts'] )
							? ( is_array( $midi_template_args['meta_parts'] )
								? $midi_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $midi_template_args['meta_parts'] ) )
								)
							: midi_array_get_keys_by_value( midi_get_theme_option( 'meta_parts' ) );
	midi_show_post_featured( apply_filters( 'midi_filter_args_featured',
		array(
			'no_links'   => ! empty( $midi_template_args['no_links'] ),
			'hover'      => $midi_hover,
			'meta_parts' => $midi_components,
			'thumb_size' => ! empty( $midi_template_args['thumb_size'] )
							? $midi_template_args['thumb_size']
							: midi_get_thumb_size( strpos( midi_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $midi_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$midi_template_args
	) );

	// Title and post meta
	$midi_show_title = get_the_title() != '';
	$midi_show_meta  = count( $midi_components ) > 0 && ! in_array( $midi_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $midi_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'midi_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'midi_action_before_post_title' );
				if ( empty( $midi_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'midi_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'midi_filter_show_blog_excerpt', empty( $midi_template_args['hide_excerpt'] ) && midi_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'midi_filter_show_blog_meta', $midi_show_meta, $midi_components, 'excerpt' ) ) {
				if ( count( $midi_components ) > 0 ) {
					do_action( 'midi_action_before_post_meta' );
					midi_show_post_meta(
						apply_filters(
							'midi_filter_post_meta_args', array(
								'components' => join( ',', $midi_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'midi_action_after_post_meta' );
				}
			}

			if ( midi_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'midi_action_before_full_post_content' );
					the_content( '' );
					do_action( 'midi_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'midi' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'midi' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				midi_show_post_content( $midi_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'midi_filter_show_blog_readmore',  ! isset( $midi_template_args['more_button'] ) || ! empty( $midi_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $midi_template_args['no_links'] ) ) {
					do_action( 'midi_action_before_post_readmore' );
					if ( midi_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						midi_show_post_more_link( $midi_template_args, '<p>', '</p>' );
					} else {
						midi_show_post_comments_link( $midi_template_args, '<p>', '</p>' );
					}
					do_action( 'midi_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $midi_template_args ) ) {
	if ( ! empty( $midi_template_args['slider'] ) || $midi_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
