<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package MIDI
 * @since MIDI 1.0
 */

$midi_template_args = get_query_var( 'midi_template_args' );

if ( is_array( $midi_template_args ) ) {
	$midi_columns    = empty( $midi_template_args['columns'] ) ? 2 : max( 1, $midi_template_args['columns'] );
	$midi_blog_style = array( $midi_template_args['type'], $midi_columns );
    $midi_columns_class = midi_get_column_class( 1, $midi_columns, ! empty( $midi_template_args['columns_tablet']) ? $midi_template_args['columns_tablet'] : '', ! empty($midi_template_args['columns_mobile']) ? $midi_template_args['columns_mobile'] : '' );
} else {
	$midi_template_args = array();
	$midi_blog_style = explode( '_', midi_get_theme_option( 'blog_style' ) );
	$midi_columns    = empty( $midi_blog_style[1] ) ? 2 : max( 1, $midi_blog_style[1] );
    $midi_columns_class = midi_get_column_class( 1, $midi_columns );
}
$midi_expanded   = ! midi_sidebar_present() && midi_get_theme_option( 'expand_content' ) == 'expand';

$midi_post_format = get_post_format();
$midi_post_format = empty( $midi_post_format ) ? 'standard' : str_replace( 'post-format-', '', $midi_post_format );

?><div class="<?php
	if ( ! empty( $midi_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( midi_is_blog_style_use_masonry( $midi_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $midi_columns ) : esc_attr( $midi_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $midi_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $midi_columns )
				. ' post_layout_' . esc_attr( $midi_blog_style[0] )
				. ' post_layout_' . esc_attr( $midi_blog_style[0] ) . '_' . esc_attr( $midi_columns )
	);
	midi_add_blog_animation( $midi_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$midi_hover      = ! empty( $midi_template_args['hover'] ) && ! midi_is_inherit( $midi_template_args['hover'] )
							? $midi_template_args['hover']
							: midi_get_theme_option( 'image_hover' );

	$midi_components = ! empty( $midi_template_args['meta_parts'] )
							? ( is_array( $midi_template_args['meta_parts'] )
								? $midi_template_args['meta_parts']
								: explode( ',', $midi_template_args['meta_parts'] )
								)
							: midi_array_get_keys_by_value( midi_get_theme_option( 'meta_parts' ) );

	midi_show_post_featured( apply_filters( 'midi_filter_args_featured',
		array(
			'thumb_size' => ! empty( $midi_template_args['thumb_size'] )
				? $midi_template_args['thumb_size']
				: midi_get_thumb_size(
					'classic' == $midi_blog_style[0]
						? ( strpos( midi_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $midi_columns > 2 ? 'big' : 'huge' )
								: ( $midi_columns > 2
									? ( $midi_expanded ? 'square' : 'square' )
									: ($midi_columns > 1 ? 'square' : ( $midi_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( midi_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $midi_columns > 2 ? 'masonry-big' : 'full' )
								: ($midi_columns === 1 ? ( $midi_expanded ? 'huge' : 'big' ) : ( $midi_columns <= 2 && $midi_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $midi_hover,
			'meta_parts' => $midi_components,
			'no_links'   => ! empty( $midi_template_args['no_links'] ),
        ),
        'content-classic',
        $midi_template_args
    ) );

	// Title and post meta
	$midi_show_title = get_the_title() != '';
	$midi_show_meta  = count( $midi_components ) > 0 && ! in_array( $midi_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $midi_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'midi_filter_show_blog_meta', $midi_show_meta, $midi_components, 'classic' ) ) {
				if ( count( $midi_components ) > 0 ) {
					do_action( 'midi_action_before_post_meta' );
					midi_show_post_meta(
						apply_filters(
							'midi_filter_post_meta_args', array(
							'components' => join( ',', $midi_components ),
							'seo'        => false,
							'echo'       => true,
						), $midi_blog_style[0], $midi_columns
						)
					);
					do_action( 'midi_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'midi_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'midi_action_before_post_title' );
				if ( empty( $midi_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'midi_action_after_post_title' );
			}

			if( !in_array( $midi_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'midi_filter_show_blog_readmore', ! $midi_show_title || ! empty( $midi_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $midi_template_args['no_links'] ) ) {
						do_action( 'midi_action_before_post_readmore' );
						midi_show_post_more_link( $midi_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'midi_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $midi_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('midi_filter_show_blog_excerpt', empty($midi_template_args['hide_excerpt']) && midi_get_theme_option('excerpt_length') > 0, 'classic')) {
			midi_show_post_content($midi_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $midi_template_args['more_button'] )) {
			if ( empty( $midi_template_args['no_links'] ) ) {
				do_action( 'midi_action_before_post_readmore' );
				midi_show_post_more_link( $midi_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'midi_action_after_post_readmore' );
			}
		}
		$midi_content = ob_get_contents();
		ob_end_clean();
		midi_show_layout($midi_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
