<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package MIDI
 * @since MIDI 1.71.0
 */

$midi_template_args = get_query_var( 'midi_template_args' );
if ( ! is_array( $midi_template_args ) ) {
	$midi_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$midi_columns       = 1;

$midi_expanded      = ! midi_sidebar_present() && midi_get_theme_option( 'expand_content' ) == 'expand';

$midi_post_format   = get_post_format();
$midi_post_format   = empty( $midi_post_format ) ? 'standard' : str_replace( 'post-format-', '', $midi_post_format );

if ( is_array( $midi_template_args ) ) {
	$midi_columns    = empty( $midi_template_args['columns'] ) ? 1 : max( 1, $midi_template_args['columns'] );
	$midi_blog_style = array( $midi_template_args['type'], $midi_columns );
	if ( ! empty( $midi_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $midi_columns > 1 ) {
	    $midi_columns_class = midi_get_column_class( 1, $midi_columns, ! empty( $midi_template_args['columns_tablet']) ? $midi_template_args['columns_tablet'] : '', ! empty($midi_template_args['columns_mobile']) ? $midi_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $midi_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $midi_post_format ) );
	midi_add_blog_animation( $midi_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$midi_hover      = ! empty( $midi_template_args['hover'] ) && ! midi_is_inherit( $midi_template_args['hover'] )
							? $midi_template_args['hover']
							: midi_get_theme_option( 'image_hover' );
	$midi_components = ! empty( $midi_template_args['meta_parts'] )
							? ( is_array( $midi_template_args['meta_parts'] )
								? $midi_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $midi_template_args['meta_parts'] ) )
								)
							: midi_array_get_keys_by_value( midi_get_theme_option( 'meta_parts' ) );
	midi_show_post_featured( apply_filters( 'midi_filter_args_featured',
		array(
			'no_links'   => ! empty( $midi_template_args['no_links'] ),
			'hover'      => $midi_hover,
			'meta_parts' => $midi_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $midi_template_args['thumb_size'] )
								? $midi_template_args['thumb_size']
								: midi_get_thumb_size( 
								in_array( $midi_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( midi_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $midi_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$midi_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$midi_show_title = get_the_title() != '';
		$midi_show_meta  = count( $midi_components ) > 0 && ! in_array( $midi_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $midi_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'midi_filter_show_blog_categories', $midi_show_meta && in_array( 'categories', $midi_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'midi_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						midi_show_post_meta( apply_filters(
															'midi_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $midi_hover, 1
															)
											);
						?>
					</div>
					<?php
					$midi_components = midi_array_delete_by_value( $midi_components, 'categories' );
					do_action( 'midi_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'midi_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'midi_action_before_post_title' );
					if ( empty( $midi_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'midi_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $midi_template_args['excerpt_length'] ) && ! in_array( $midi_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$midi_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'midi_filter_show_blog_excerpt', empty( $midi_template_args['hide_excerpt'] ) && midi_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				midi_show_post_content( $midi_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'midi_filter_show_blog_meta', $midi_show_meta, $midi_components, 'band' ) ) {
			if ( count( $midi_components ) > 0 ) {
				do_action( 'midi_action_before_post_meta' );
				midi_show_post_meta(
					apply_filters(
						'midi_filter_post_meta_args', array(
							'components' => join( ',', $midi_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'midi_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'midi_filter_show_blog_readmore', ! $midi_show_title || ! empty( $midi_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $midi_template_args['no_links'] ) ) {
				do_action( 'midi_action_before_post_readmore' );
				midi_show_post_more_link( $midi_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'midi_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $midi_template_args ) ) {
	if ( ! empty( $midi_template_args['slider'] ) || $midi_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
