<?php
/**
 * The Header: Logo and main menu
 *
 * @package MIDI
 * @since MIDI 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( midi_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'midi_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'midi_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('midi_action_body_wrap_attributes'); ?>>

		<?php do_action( 'midi_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'midi_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('midi_action_page_wrap_attributes'); ?>>

			<?php do_action( 'midi_action_page_wrap_start' ); ?>

			<?php
			$midi_full_post_loading = ( midi_is_singular( 'post' ) || midi_is_singular( 'attachment' ) ) && midi_get_value_gp( 'action' ) == 'full_post_loading';
			$midi_prev_post_loading = ( midi_is_singular( 'post' ) || midi_is_singular( 'attachment' ) ) && midi_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $midi_full_post_loading && ! $midi_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="midi_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'midi_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'midi' ); ?></a>
				<?php if ( midi_sidebar_present() ) { ?>
				<a class="midi_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'midi_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'midi' ); ?></a>
				<?php } ?>
				<a class="midi_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'midi_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'midi' ); ?></a>

				<?php
				do_action( 'midi_action_before_header' );

				// Header
				$midi_header_type = midi_get_theme_option( 'header_type' );
				if ( 'custom' == $midi_header_type && ! midi_is_layouts_available() ) {
					$midi_header_type = 'default';
				}
				get_template_part( apply_filters( 'midi_filter_get_template_part', "templates/header-" . sanitize_file_name( $midi_header_type ) ) );

				// Side menu
				if ( in_array( midi_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'midi_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'midi_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'midi_action_after_header' );

			}
			?>

			<?php do_action( 'midi_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( midi_is_off( midi_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $midi_header_type ) ) {
						$midi_header_type = midi_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $midi_header_type && midi_is_layouts_available() ) {
						$midi_header_id = midi_get_custom_header_id();
						if ( $midi_header_id > 0 ) {
							$midi_header_meta = midi_get_custom_layout_meta( $midi_header_id );
							if ( ! empty( $midi_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$midi_footer_type = midi_get_theme_option( 'footer_type' );
					if ( 'custom' == $midi_footer_type && midi_is_layouts_available() ) {
						$midi_footer_id = midi_get_custom_footer_id();
						if ( $midi_footer_id ) {
							$midi_footer_meta = midi_get_custom_layout_meta( $midi_footer_id );
							if ( ! empty( $midi_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'midi_action_page_content_wrap_class', $midi_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'midi_filter_is_prev_post_loading', $midi_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( midi_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'midi_action_page_content_wrap_data', $midi_prev_post_loading );
			?>>
				<?php
				do_action( 'midi_action_page_content_wrap', $midi_full_post_loading || $midi_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'midi_filter_single_post_header', midi_is_singular( 'post' ) || midi_is_singular( 'attachment' ) ) ) {
					if ( $midi_prev_post_loading ) {
						if ( midi_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'midi_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$midi_path = apply_filters( 'midi_filter_get_template_part', 'templates/single-styles/' . midi_get_theme_option( 'single_style' ) );
					if ( midi_get_file_dir( $midi_path . '.php' ) != '' ) {
						get_template_part( $midi_path );
					}
				}

				// Widgets area above page
				$midi_body_style   = midi_get_theme_option( 'body_style' );
				$midi_widgets_name = midi_get_theme_option( 'widgets_above_page', 'hide' );
				$midi_show_widgets = ! midi_is_off( $midi_widgets_name ) && is_active_sidebar( $midi_widgets_name );
				if ( $midi_show_widgets ) {
					if ( 'fullscreen' != $midi_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					midi_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $midi_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'midi_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $midi_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'midi_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'midi_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="midi_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( midi_is_singular( 'post' ) || midi_is_singular( 'attachment' ) )
							&& $midi_prev_post_loading 
							&& midi_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'midi_action_between_posts' );
						}

						// Widgets area above content
						midi_create_widgets_area( 'widgets_above_content' );

						do_action( 'midi_action_page_content_start_text' );
