<?php
$midi_woocommerce_sc = midi_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $midi_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$midi_scheme = midi_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $midi_scheme ) && ! midi_is_inherit( $midi_scheme ) ) {
			echo ' scheme_' . esc_attr( $midi_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( midi_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( midi_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$midi_css      = '';
			$midi_bg_image = midi_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $midi_bg_image ) ) {
				$midi_css .= 'background-image: url(' . esc_url( midi_get_attachment_url( $midi_bg_image ) ) . ');';
			}
			if ( ! empty( $midi_css ) ) {
				echo ' style="' . esc_attr( $midi_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$midi_anchor_icon = midi_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$midi_anchor_text = midi_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $midi_anchor_icon ) || ! empty( $midi_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $midi_anchor_icon ) ? ' icon="' . esc_attr( $midi_anchor_icon ) . '"' : '' )
											. ( ! empty( $midi_anchor_text ) ? ' title="' . esc_attr( $midi_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( midi_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' midi-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$midi_css      = '';
				$midi_bg_mask  = midi_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$midi_bg_color_type = midi_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $midi_bg_color_type ) {
					$midi_bg_color = midi_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $midi_bg_color_type ) {
					$midi_bg_color = midi_get_scheme_color( 'bg_color', $midi_scheme );
				} else {
					$midi_bg_color = '';
				}
				if ( ! empty( $midi_bg_color ) && $midi_bg_mask > 0 ) {
					$midi_css .= 'background-color: ' . esc_attr(
						1 == $midi_bg_mask ? $midi_bg_color : midi_hex2rgba( $midi_bg_color, $midi_bg_mask )
					) . ';';
				}
				if ( ! empty( $midi_css ) ) {
					echo ' style="' . esc_attr( $midi_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$midi_caption     = midi_get_theme_option( 'front_page_woocommerce_caption' );
				$midi_description = midi_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $midi_caption ) || ! empty( $midi_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $midi_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $midi_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $midi_caption, 'midi_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $midi_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $midi_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $midi_description ), 'midi_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $midi_woocommerce_sc ) {
						$midi_woocommerce_sc_ids      = midi_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$midi_woocommerce_sc_per_page = count( explode( ',', $midi_woocommerce_sc_ids ) );
					} else {
						$midi_woocommerce_sc_per_page = max( 1, (int) midi_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$midi_woocommerce_sc_columns = max( 1, min( $midi_woocommerce_sc_per_page, (int) midi_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$midi_woocommerce_sc}"
										. ( 'products' == $midi_woocommerce_sc
												? ' ids="' . esc_attr( $midi_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $midi_woocommerce_sc
												? ' category="' . esc_attr( midi_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $midi_woocommerce_sc
												? ' orderby="' . esc_attr( midi_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( midi_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $midi_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $midi_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
