<?php
$midi_slider_sc = midi_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $midi_slider_sc ) && strpos( $midi_slider_sc, '[' ) !== false && strpos( $midi_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( midi_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$midi_anchor_icon = midi_get_theme_option( 'front_page_title_anchor_icon' );
		$midi_anchor_text = midi_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $midi_anchor_icon ) || ! empty( $midi_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $midi_anchor_icon ) ? ' icon="' . esc_attr( $midi_anchor_icon ) . '"' : '' )
									. ( ! empty( $midi_anchor_text ) ? ' title="' . esc_attr( $midi_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $midi_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$midi_scheme = midi_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $midi_scheme ) && ! midi_is_inherit( $midi_scheme ) ) {
			echo ' scheme_' . esc_attr( $midi_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( midi_get_theme_option( 'front_page_title_paddings' ) );
		if ( midi_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$midi_css      = '';
		$midi_bg_image = midi_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $midi_bg_image ) ) {
			$midi_css .= 'background-image: url(' . esc_url( midi_get_attachment_url( $midi_bg_image ) ) . ');';
		}
		if ( ! empty( $midi_css ) ) {
			echo ' style="' . esc_attr( $midi_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$midi_anchor_icon = midi_get_theme_option( 'front_page_title_anchor_icon' );
		$midi_anchor_text = midi_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $midi_anchor_icon ) || ! empty( $midi_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $midi_anchor_icon ) ? ' icon="' . esc_attr( $midi_anchor_icon ) . '"' : '' )
									. ( ! empty( $midi_anchor_text ) ? ' title="' . esc_attr( $midi_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( midi_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' midi-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$midi_css      = '';
			$midi_bg_mask  = midi_get_theme_option( 'front_page_title_bg_mask' );
			$midi_bg_color_type = midi_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $midi_bg_color_type ) {
				$midi_bg_color = midi_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $midi_bg_color_type ) {
				$midi_bg_color = midi_get_scheme_color( 'bg_color', $midi_scheme );
			} else {
				$midi_bg_color = '';
			}
			if ( ! empty( $midi_bg_color ) && $midi_bg_mask > 0 ) {
				$midi_css .= 'background-color: ' . esc_attr(
					1 == $midi_bg_mask ? $midi_bg_color : midi_hex2rgba( $midi_bg_color, $midi_bg_mask )
				) . ';';
			}
			if ( ! empty( $midi_css ) ) {
				echo ' style="' . esc_attr( $midi_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$midi_caption = midi_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $midi_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $midi_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $midi_caption, 'midi_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$midi_description = midi_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $midi_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $midi_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $midi_description ), 'midi_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( midi_get_theme_option( 'front_page_title_button1_link' ) != '' || midi_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						midi_show_layout( midi_customizer_partial_refresh_front_page_title_button1_link() );
						midi_show_layout( midi_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
