<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package MIDI
 * @since MIDI 1.0
 */

							do_action( 'midi_action_page_content_end_text' );
							
							// Widgets area below the content
							midi_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'midi_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'midi_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'midi_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'midi_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$midi_body_style = midi_get_theme_option( 'body_style' );
					$midi_widgets_name = midi_get_theme_option( 'widgets_below_page', 'hide' );
					$midi_show_widgets = ! midi_is_off( $midi_widgets_name ) && is_active_sidebar( $midi_widgets_name );
					$midi_show_related = midi_is_single() && midi_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $midi_show_widgets || $midi_show_related ) {
						if ( 'fullscreen' != $midi_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $midi_show_related ) {
							do_action( 'midi_action_related_posts' );
						}

						// Widgets area below page content
						if ( $midi_show_widgets ) {
							midi_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $midi_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'midi_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'midi_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! midi_is_singular( 'post' ) && ! midi_is_singular( 'attachment' ) ) || ! in_array ( midi_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="midi_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'midi_action_before_footer' );

				// Footer
				$midi_footer_type = midi_get_theme_option( 'footer_type' );
				if ( 'custom' == $midi_footer_type && ! midi_is_layouts_available() ) {
					$midi_footer_type = 'default';
				}
				get_template_part( apply_filters( 'midi_filter_get_template_part', "templates/footer-" . sanitize_file_name( $midi_footer_type ) ) );

				do_action( 'midi_action_after_footer' );

			}
			?>

			<?php do_action( 'midi_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'midi_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'midi_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>